<?php
/**
 * VXe    FgъGϊ
 *
 * <pre>
 * :    :    :    :    :    :    :    :    :    :    :    :    :    :    :    :    :
 * [vOTv]
 * DoCoMoɓ͂GAANZXĂLAɍ킹
 * IɌ݊G(R[h)ɒu܂B
 * DoCoMoG̓͂́A֐̈ɊG̓\tggĒړ͂邩A
 * 16i@ɗ^鎖ɂ܂(16i@ł)
 *
 * :    :    :    :    :    :    :    :    :    :    :    :    :    :    :    :    :
 * </pre>
 *
 * @since            2006/11/20
 * @author           T.Kotaka
 * @packege          MobileClass
 * @version          $Id: MobileClass.php,v 2.0 2008/11/14 11:49:07 t-kotaka Exp $
 *
 * <pre>
 * [\bhꗗ]
 *  1) __construct             (public)     RXgN^
 *  2) MobileClass             (public)     RXgN^(__construct\bhR[)
 *  3) getErrorMessage         (public)     OɔG[bZ[Wԋp܂B
 *  4) setImageUrl             (public)     G摜̐ݒuURLZbg܂
 *  5) Convert                 (public)     Ŏw肳ꂽGR[hAeLAɍ킹GR[hɕϊԋp
 *  6) ConvertAll              (public)     Recɖߍ܂ꂽGeLAɍ킹Ĉꊇu܂B
 *  7) getEmojiVars            (public)     Ge[uϊXgԋp
 *  8) _setErrorMessage        (private)    G[bZ[WZbg܂
 *  9) _setUserAgent           (private)    ANZX[̃[U[G[WFgoϐɃZbg
 * 10) _setEmojiTable          (private)    Ge[uZbg܂
 *
 *
 * [ŗ]
 * 000001    2006/11/20    (VK) VK쐬
 * 000002    2007/01/22    (ǉ) 16i@ɂ͂T|[g܂B
 * 000003    2007/01/22    (C) [U[G[WFguSoftBankv̍ۂɁAGϊȂsC܂B
 * 000004    2007/01/23    (C) EzWebɂāAG̑֕o͏oȂsC܂B
 * 000005    2007/02/20    (C) eLA̎ʔԍ萔Ɉڍs܂B
 * 000006    2007/02/22    (ǉ) getErrorMessage\bhǉ܂B
 * 000007    2007/02/22    (C) eG[bZ[W萔ɂ܂Ƃ߂܂B
 * 000008    2008/01/23    (ǉ) ConvertAll\bhǉ܂B
 * 000009    2008/08/19    (ǉ) _setUserAgent()\bhC(SoftBankV~[^̃G[WFgfǉ)
 * 000010    2008/09/09    (ǉ) setEmojiUrl()\bhǉ܂B
 * </pre>
 */

// {{{ constants

/**
 * [U[G[WFg^CviDoCoMoj
 */
 define('MB_USER_AGENT_DOCOMO',                  1);

/**
 * [U[G[WFg^CviSoftBankj
 */
 define('MB_USER_AGENT_SOFTBANK',                2);

/**
 * [U[G[WFg^CviEzWebj
 */
 define('MB_USER_AGENT_EZWEB',                   3);

/**
 * [U[G[WFg^Cvȋj
 */
 define('MB_USER_AGENT_OTHERS',                  4);

/**
 * NXG[bZ[W
 */
 define('ERROR_MESSAGE_INPUTEMOJI',              '\GR[hAႵ͊G̈܂B');

/**
 * NXG[bZ[W
 */
 define('ERROR_MESSAGE_INPUTMODE',               '̓[h̎w肪܂B');

/**
 * NXG[bZ[W
 */
 define('ERROR_MESSAGE_NOT_EXISTS_TO_DOCOMO',    'G܂B');

// }}}

class MobileClass {

    // {{{ properties

    /**
     * Ge[u
     *
     * @var array
     * @access private
     */
    var $_emoji            = array();

    /**
     *͕i0FoCíA1FGړ́j
     *
     * @var integer
     * @access public
     */
    var $InputMode         = 0;

    /**
     * G[bZ[W
     *
     * @var string
     * @access private
     */
    var $_error_message   = '';

    /**
     * _access_user_agent of [U[G[WFg
     *
     * @var integer
     * @access private
     */
    var $_access_user_agent      = null;

    /**
     * emoji_image_dir of G摜URL
     *
     * @var string
     * @access public
     */
    var $_emoji_image_url = 'emoji/';

    // }}}
    // {{{ construct

   /**
    * RXgN^(PHP5Ή)
    */
    function __construct($_emoji_image_url = '')
    {
        // Ge[uZbg
        $this->_setEmojiTable();

        // [U[G[WFgZbg
        $this->_setUserAgent();

        // G摜URL̃Zbg
        if (!empty($_emoji_image_url)) $this->setImageUrl($_emoji_image_url);

    }

   /**
    * RXgN^
    */
    function MobileClass($_emoji_image_url = '')
    {
        $this->__construct($_emoji_image_url);
    }

    // }}}
    // {{{ getErrorMessage()

    /**
     * OɔG[bZ[Wԋp܂B
     *
     * <code>
     * require_once 'MobileClass.php';
     * $MobileClass = new MobileClass();
     *
     * // w肵ĂȂ
     * $MobileClass->Convert();
     * $MobileClass->getErrorMessage();
     * </code>
     *
     * @return boolean OɔG[ɑ΂G[bZ[Wԋp
     * @access public
     */
    function getErrorMessage()
    {
        return $this->_error_message == '' ? false : $this->_error_message;
    }

    // }}}
    // {{{ setImageUrl()

    /**
     * G摜̐ݒuURLZbg܂
     *
     * <code>
     * // CX^XɃZbg
     * require_once 'MobileClass.php';
     * // GURL
     * $url = 'http://www.example.com/img/emoji/';
     * $MobileClass = new MobileClass($url);
     *
     * </code>
     * Or
     * <code>
     * CX^XɃ\bhR[
     * require_once 'MobileClass.php';
     * // GURL
     * $url = 'http://www.example.com/img/emoji/';
     * $MobileClass = new MobileClass();
     * $MobileClass->setImageUrl($url);
     *
     * </code>
     *
     * @access public
     */
    function setImageUrl($_emoji_image_url)
    {
        $this->_emoji_image_url = $_emoji_image_url;
    }

    // }}}
    // {{{ Convert()

    /**
     * Ŏw肳ꂽGR[hAeLAɍ킹GR[hɕϊԋp
     *
     * <code>
     * require_once 'MobileClass.php';
     * $MobileClass = new MobileClass();
     *
     * echo $MobileClass->Convert('F89F');
     * </code>
     *
     * @param  string $InputEmoji Gϊf[^
     * @return string LAɕϊꂽGf[^
     * @access public
     */
    function & Convert($InputEmoji = '')
    {
        if ($InputEmoji == '' ) {
            $this->_setErrorMessage(ERROR_MESSAGE_INPUTEMOJI);
            return false;
        }
        switch ($this->InputMode) {
        // oCi
        case 0:
            $InputEmoji = strtoupper($InputEmoji);
            break;
        // G
        case 1:
            $InputEmoji = strtoupper(bin2hex($InputEmoji));
            break;
        default:
            $this->_setErrorMessage(ERROR_MESSAGE_INPUTMODE);
            return false;
            break;
        }
        if (is_null($this->_access_user_agent)) { $this->_setUserAgent(); }
        // YGꍇ
        if (!array_key_exists($InputEmoji, $this->_emoji)){
            $this->_setErrorMessage(ERROR_MESSAGE_NOT_EXISTS_TO_DOCOMO);
            return false;
        }
        switch ($this->_access_user_agent) {
            case MB_USER_AGENT_DOCOMO:
                // DoCoMo
                $InputEmoji = pack("H*",$InputEmoji);
                break;
            case MB_USER_AGENT_SOFTBANK:
                // SoftBank
                $InputEmoji = $this->_emoji[$InputEmoji]['SB'];
                break;
            case MB_USER_AGENT_EZWEB:
                // EzWeb
                if (preg_match('/^[0-9]{0,3}$/', $this->_emoji[$InputEmoji]['EzWeb'])) {
                    $InputEmoji = sprintf('<img localsrc=%s>', $this->_emoji[$InputEmoji]['EzWeb']);
                } else {
                    $InputEmoji = $this->_emoji[$InputEmoji]['EzWeb'];
                }
                break;
            case MB_USER_AGENT_OTHERS:
                // PC
                $InputEmoji = sprintf('<img src="%s%s.gif">'
                                     ,$this->_emoji_image_url
                                     ,$InputEmoji
                                     );
                break;
        }
        return $InputEmoji;
    }

    // }}}
    // {{{ ConvertAll()

    /**
     * Recɖߍ܂ꂽGeLAɍ킹Ĉꊇu܂B
     *
     * <code>
     * require_once 'MobileClass.php';
     * $MobileClass = new MobileClass();
     *
     * $strContents = file_get_contents('./index.htm')
     * echo $MobileClass->ConvertAll($strContents);
     * </code>
     *
     * @param  string $strContents GϊHTMLRect@C
     * @return string Ŏw肳ꂽAG[WFgɂ킹\L@ɕϊԋp
     * @access public
     */
    function & ConvertAll($strContents)
    {
        // DoCoMo͕ϊ̕Kv̂ł̂܂ܕԋp
        if ($this->_access_user_agent === MB_USER_AGENT_DOCOMO) return $strContents;

        $strHexData = strtoupper(bin2hex($strContents));
        switch ($this->_access_user_agent) {
            case MB_USER_AGENT_SOFTBANK:
                foreach ($this->_emoji as $aryKey => $aryVal) {
                    if (strstr($strHexData, $aryKey)) {
                        $strRepack = pack("H*",$aryKey);
                        $aryReplaceEmoji[$strRepack] = $aryVal['SB'];
                    }
                }
                break;
            case MB_USER_AGENT_EZWEB:
                foreach ($this->_emoji as $aryKey => $aryVal) {
                    if (strstr($strHexData, $aryKey)) {
                        $strRepack = pack("H*",$aryKey);
                        $aryReplaceEmoji[$strRepack] = sprintf('<img localsrc=%s>'
                                                              ,$aryVal['EzWeb']
                                                              );
                    }
                }
                break;
            case MB_USER_AGENT_OTHERS:
                foreach ($this->_emoji as $aryKey => $aryVal) {
                    if (strstr($strHexData, $aryKey)) {
                        $strRepack = pack("H*",$aryKey);
                        $aryReplaceEmoji[$strRepack] = sprintf('<img src="%s%s.gif">'
                                                              ,$this->_emoji_image_url
                                                              ,$aryKey
                                                              );
                    }
                }
                break;
        }

        if (is_array($aryReplaceEmoji)) {
            foreach ($aryReplaceEmoji as $aryKey => $aryVal) {
                $strContents =& str_replace($aryKey, $aryVal, $strContents);
            }
        }
        return $strContents;
    }

    // }}}
    // {{{ getEmojiVars()

    /**
     * GϊXge[uԋp
     *
     * <code>
     * require_once 'MobileClass.php';
     * $MobileClass = new MobileClass();
     * $this->getEmojiVars();
     * </code>
     *
     * @return array  Ge[u
     * @access public
     */
    function getEmojiVars()
    {
        return $this->_emoji;
    }

    // }}}
    // {{{ _setErrorMessage()

    /**
     * MobileClass\bhŃG[ۂɁAG[bZ[WZbg܂
     *
     * <code>
     * require_once 'MobileClass.php';
     * $MobileClass = new MobileClass();
     *
     * $this->_setErrorMessage(ERROR_MESSAGE_INPUTEMOJI);
     * </code>
     *
     * @param  string $_error_message ZbgG[bZ[W
     * @access private
     */
    function _setErrorMessage($_error_message = '')
    {
        $this->_error_message = $_error_message;
    }

    // }}}
    // {{{ _setUserAgent()

    /**
     * ANZX[̃[U[G[WFgoϐɃZbg
     *
     * <code>
     * $this->_setUserAgent();
     * </code>
     *
     * @access private
     */
    function _setUserAgent()
    {
        $UA = $_SERVER['HTTP_USER_AGENT'];
        if (strstr($UA,'DoCoMo')) {
            $this->_access_user_agent = MB_USER_AGENT_DOCOMO;
        } elseif (strstr($UA,'J-PHONE') || strstr($UA,'Vodafone') || strstr($UA, 'SoftBank') ||
                  strstr($UA,'Semulator') || strstr($UA,'Vemulator') || strstr($UA, 'J-EMULATOR') ||
                  strstr($UA,'MOTEMULATOR')) {
            $this->_access_user_agent = MB_USER_AGENT_SOFTBANK;
        } elseif (strstr($UA,'UP.Browser')) {
            $this->_access_user_agent = MB_USER_AGENT_EZWEB;
        } else {
            $this->_access_user_agent = MB_USER_AGENT_OTHERS;
        }
    }

    // }}}
    // {{{ _setEmojiTable()

    /**
     * GϊXge[uZbg܂B
     *
     * <code>
     * $this->_setEmojiTable();
     * </code>
     *
     * @access private
     */
    function _setEmojiTable()
    {
        // 2006/11/20 Ή
        $this->_emoji['F89F'] = array('TIT' => '',              'EzWeb' => '44',              'SB' => '$Gj');
        $this->_emoji['F8A0'] = array('TIT' => '܂',              'EzWeb' => '107',             'SB' => '$Gi');
        $this->_emoji['F8A1'] = array('TIT' => 'J',                'EzWeb' => '95',              'SB' => '$Gk');
        $this->_emoji['F8A2'] = array('TIT' => '',                'EzWeb' => '191',             'SB' => '$Gh');
        $this->_emoji['F8A3'] = array('TIT' => '',                'EzWeb' => '16',              'SB' => '$E]');
        $this->_emoji['F8A4'] = array('TIT' => '䕗',              'EzWeb' => '190',             'SB' => '$Pc');
        $this->_emoji['F8A5'] = array('TIT' => '',                'EzWeb' => '305',             'SB' => '[]');
        $this->_emoji['F8A6'] = array('TIT' => 'J',              'EzWeb' => '481',             'SB' => '$P\');
        $this->_emoji['F8A7'] = array('TIT' => 'r',            'EzWeb' => '192',             'SB' => '$F_');
        $this->_emoji['F8A8'] = array('TIT' => '',            'EzWeb' => '193',             'SB' => '$F`');
        $this->_emoji['F8A9'] = array('TIT' => 'oq',            'EzWeb' => '194',             'SB' => '$Fa');
        $this->_emoji['F8AA'] = array('TIT' => 'I',              'EzWeb' => '195',             'SB' => '$Fb');
        $this->_emoji['F8AB'] = array('TIT' => 'q',            'EzWeb' => '196',             'SB' => '$Fc');
        $this->_emoji['F8AC'] = array('TIT' => '',            'EzWeb' => '197',             'SB' => '$Fd');
        $this->_emoji['F8AD'] = array('TIT' => 'V',            'EzWeb' => '198',             'SB' => '$Fe');
        $this->_emoji['F8AE'] = array('TIT' => '嶍',              'EzWeb' => '199',             'SB' => '$Ff');
        $this->_emoji['F8AF'] = array('TIT' => 'ˎ',            'EzWeb' => '200',             'SB' => '$Fg');
        $this->_emoji['F8B0'] = array('TIT' => 'Rr',            'EzWeb' => '201',             'SB' => '$Fh');
        $this->_emoji['F8B1'] = array('TIT' => 'r',            'EzWeb' => '202',             'SB' => '$Fi');
        $this->_emoji['F8B2'] = array('TIT' => '',              'EzWeb' => '203',             'SB' => '$Fj');
        $this->_emoji['F8B3'] = array('TIT' => 'X|[c',          'EzWeb' => '-',               'SB' => '-');
        $this->_emoji['F8B4'] = array('TIT' => '싅',              'EzWeb' => '45',              'SB' => '$G6');
        $this->_emoji['F8B5'] = array('TIT' => 'St',            'EzWeb' => '306',             'SB' => '$G4');
        $this->_emoji['F8B6'] = array('TIT' => 'ejX',            'EzWeb' => '220',             'SB' => '$G5');
        $this->_emoji['F8B7'] = array('TIT' => 'TbJ[',          'EzWeb' => '219',             'SB' => '$G8');
        $this->_emoji['F8B8'] = array('TIT' => 'XL[',            'EzWeb' => '421',             'SB' => '$G3');
        $this->_emoji['F8B9'] = array('TIT' => 'oXPbg{[',  'EzWeb' => '307',             'SB' => '$PJ');
        $this->_emoji['F8BA'] = array('TIT' => '[^[X|[c',  'EzWeb' => '222',             'SB' => '$ER');
        $this->_emoji['F8BB'] = array('TIT' => '|Pbgx',      'EzWeb' => '308',             'SB' => '[PB]');
        $this->_emoji['F8BC'] = array('TIT' => 'd',              'EzWeb' => '172',             'SB' => '$G>');
        $this->_emoji['F8BD'] = array('TIT' => 'nS',            'EzWeb' => '341',             'SB' => '$PT');
        $this->_emoji['F8BE'] = array('TIT' => 'V',            'EzWeb' => '217',             'SB' => '$PU');
        $this->_emoji['F8BF'] = array('TIT' => 'ԁiZ_j',      'EzWeb' => '125',             'SB' => '$G;');
        $this->_emoji['F8C0'] = array('TIT' => 'ԁiquj',        'EzWeb' => '125',             'SB' => '$PN');
        $this->_emoji['F8C1'] = array('TIT' => 'oX',              'EzWeb' => '216',             'SB' => '$Ey');
        $this->_emoji['F8C2'] = array('TIT' => 'D',                'EzWeb' => '379',             'SB' => '$F"');
        $this->_emoji['F8C3'] = array('TIT' => 's@',            'EzWeb' => '168',             'SB' => '$G=');
        $this->_emoji['F8C4'] = array('TIT' => '',                'EzWeb' => '112',             'SB' => '$GV');
        $this->_emoji['F8C5'] = array('TIT' => 'r',              'EzWeb' => '156',             'SB' => '$GX');
        $this->_emoji['F8C6'] = array('TIT' => 'X֋',            'EzWeb' => '375',             'SB' => '$Es');
        $this->_emoji['F8C7'] = array('TIT' => 'a@',              'EzWeb' => '376',             'SB' => '$Eu');
        $this->_emoji['F8C8'] = array('TIT' => 's',              'EzWeb' => '212',             'SB' => '$Em');
        $this->_emoji['F8C9'] = array('TIT' => '`sl',            'EzWeb' => '205',             'SB' => '$Et');
        $this->_emoji['F8CA'] = array('TIT' => 'ze',            'EzWeb' => '378',             'SB' => '$Ex');
        $this->_emoji['F8CB'] = array('TIT' => 'Rrj',          'EzWeb' => '206',             'SB' => '$Ev');
        $this->_emoji['F8CC'] = array('TIT' => 'K\X^h',  'EzWeb' => '213',             'SB' => '$GZ');
        $this->_emoji['F8CD'] = array('TIT' => 'ԏ',            'EzWeb' => '208',             'SB' => '$Eo');
        $this->_emoji['F8CE'] = array('TIT' => 'M',              'EzWeb' => '99',              'SB' => '$En');
        $this->_emoji['F8CF'] = array('TIT' => 'gC',            'EzWeb' => '207',             'SB' => '$Eq');
        $this->_emoji['F8D0'] = array('TIT' => 'Xg',        'EzWeb' => '146',             'SB' => '$Gc');
        $this->_emoji['F8D1'] = array('TIT' => 'iX',            'EzWeb' => '93',              'SB' => '$Ge');
        $this->_emoji['F8D2'] = array('TIT' => 'o[',              'EzWeb' => '52',              'SB' => '$Gd');
        $this->_emoji['F8D3'] = array('TIT' => 'r[',            'EzWeb' => '65',              'SB' => '$Gg');
        $this->_emoji['F8D4'] = array('TIT' => 't@[Xgt[h',  'EzWeb' => '245',             'SB' => '$E@');
        $this->_emoji['F8D5'] = array('TIT' => 'ueBbN',        'EzWeb' => '124',             'SB' => '$E^');
        $this->_emoji['F8D6'] = array('TIT' => 'e@',            'EzWeb' => '104',             'SB' => '$O3');
        $this->_emoji['F8D7'] = array('TIT' => 'JIP',          'EzWeb' => '289',             'SB' => '$G\');
        $this->_emoji['F8D8'] = array('TIT' => 'f',              'EzWeb' => '110',             'SB' => '$G]');
        $this->_emoji['F8D9'] = array('TIT' => 'E΂ߏ',          'EzWeb' => '70',              'SB' => '$FV');
        $this->_emoji['F8DA'] = array('TIT' => 'Vn',            'EzWeb' => '-', '              SB' => '-');
        $this->_emoji['F8DB'] = array('TIT' => 'y',              'EzWeb' => '294',             'SB' => '$O*');
        $this->_emoji['F8DC'] = array('TIT' => 'A[g',            'EzWeb' => '309',             'SB' => '$Q"');
        $this->_emoji['F8DD'] = array('TIT' => '',              'EzWeb' => '494',             'SB' => '$Q#');
        $this->_emoji['F8DE'] = array('TIT' => 'Cxg',          'EzWeb' => '311',             'SB' => '-');
        $this->_emoji['F8DF'] = array('TIT' => '`Pbg',          'EzWeb' => '106',             'SB' => '$EE');
        $this->_emoji['F8E0'] = array('TIT' => 'i',              'EzWeb' => '176',             'SB' => '$O.');
        $this->_emoji['F8E1'] = array('TIT' => '։',              'EzWeb' => '177',             'SB' => '$F(');
        $this->_emoji['F8E2'] = array('TIT' => 'J',            'EzWeb' => '94',              'SB' => '$G(');
        $this->_emoji['F8E3'] = array('TIT' => 'Jo',            'EzWeb' => '83',              'SB' => '$OC');
        $this->_emoji['F8E4'] = array('TIT' => '{',                'EzWeb' => '122',             'SB' => '$Eh');
        $this->_emoji['F8E5'] = array('TIT' => '{',            'EzWeb' => '312',             'SB' => '$O4');
        $this->_emoji['F8E6'] = array('TIT' => 'v[g',        'EzWeb' => '144',             'SB' => '$E2');
        $this->_emoji['F8E7'] = array('TIT' => 'o[Xf[',        'EzWeb' => '313',             'SB' => '$Ok');
        $this->_emoji['F8E8'] = array('TIT' => 'db',              'EzWeb' => '85',              'SB' => '$G)');
        $this->_emoji['F8E9'] = array('TIT' => 'gѓdb',          'EzWeb' => '161',             'SB' => '$G*');
        $this->_emoji['F8EA'] = array('TIT' => '',              'EzWeb' => '395',             'SB' => '$O!');
        $this->_emoji['F8EB'] = array('TIT' => 'su',              'EzWeb' => '288',             'SB' => '$EJ');
        $this->_emoji['F8EC'] = array('TIT' => 'Q[',            'EzWeb' => '232',             'SB' => '[Q[]');
        $this->_emoji['F8ED'] = array('TIT' => 'bc',              'EzWeb' => '300',             'SB' => '$EF');
        $this->_emoji['F8EE'] = array('TIT' => 'n[g',            'EzWeb' => '414',             'SB' => '$F,');
        $this->_emoji['F8EF'] = array('TIT' => 'Xy[h',          'EzWeb' => '314',             'SB' => '$F.');
        $this->_emoji['F8F0'] = array('TIT' => '_C',            'EzWeb' => '315',             'SB' => '$F-');
        $this->_emoji['F8F1'] = array('TIT' => 'Nu',            'EzWeb' => '316',             'SB' => '$F/');
        $this->_emoji['F8F2'] = array('TIT' => '',                'EzWeb' => '317',             'SB' => '$P9');
        $this->_emoji['F8F3'] = array('TIT' => '',                'EzWeb' => '318',             'SB' => '$P;');
        $this->_emoji['F8F4'] = array('TIT' => 'iO[j',        'EzWeb' => '817',             'SB' => '$G0');
        $this->_emoji['F8F5'] = array('TIT' => 'i`Lj',      'EzWeb' => '319',             'SB' => '$G1');
        $this->_emoji['F8F6'] = array('TIT' => 'ip[j',        'EzWeb' => '320',             'SB' => '$G2');
        $this->_emoji['F8F7'] = array('TIT' => 'E΂߉',          'EzWeb' => '43',              'SB' => '$FX');
        $this->_emoji['F8F8'] = array('TIT' => '΂ߏ',          'EzWeb' => '42',              'SB' => '$FW');
        $this->_emoji['F8F9'] = array('TIT' => '',                'EzWeb' => '728',             'SB' => '$QV');
        $this->_emoji['F8FA'] = array('TIT' => '',              'EzWeb' => '729',             'SB' => '$G\'');
        $this->_emoji['F8FB'] = array('TIT' => 'ዾ',              'EzWeb' => '116',             'SB' => '[Kl]');
        $this->_emoji['F8FC'] = array('TIT' => 'Ԉ֎q',            'EzWeb' => '178',             'SB' => '$F*');
        $this->_emoji['F940'] = array('TIT' => 'V',              'EzWeb' => '321',             'SB' => '');
        $this->_emoji['F941'] = array('TIT' => '⌇',        'EzWeb' => '322',             'SB' => '$Gl');
        $this->_emoji['F942'] = array('TIT' => '',              'EzWeb' => '323',             'SB' => '$Gl');
        $this->_emoji['F943'] = array('TIT' => 'O',            'EzWeb' => '15',              'SB' => '$Gl');
        $this->_emoji['F944'] = array('TIT' => '',              'EzWeb' => '',              'SB' => '');
        $this->_emoji['F945'] = array('TIT' => '',                'EzWeb' => '134',             'SB' => '$Gr');
        $this->_emoji['F946'] = array('TIT' => 'L',                'EzWeb' => '251',             'SB' => '$Go');
        $this->_emoji['F947'] = array('TIT' => '][g',          'EzWeb' => '169',             'SB' => '$G<');
        $this->_emoji['F948'] = array('TIT' => 'NX}X',        'EzWeb' => '234',             'SB' => '$GS');
        $this->_emoji['F949'] = array('TIT' => '΂߉',          'EzWeb' => '71',              'SB' => '$FY');
        $this->_emoji['F950'] = array('TIT' => 'J`R',          'EzWeb' => '226',             'SB' => '$OD');
        $this->_emoji['F951'] = array('TIT' => 'ӂ',            'EzWeb' => '[ӂ]',        'SB' => '[ӂ]');
        $this->_emoji['F952'] = array('TIT' => 'y',              'EzWeb' => '508',             'SB' => 'myn');
        $this->_emoji['F955'] = array('TIT' => 'le',              'EzWeb' => '-',               'SB' => '-');
        $this->_emoji['F956'] = array('TIT' => '',              'EzWeb' => '[]',          'SB' => '$E?');
        $this->_emoji['F957'] = array('TIT' => '',                'EzWeb' => '490',             'SB' => '$Pk');
        $this->_emoji['F95E'] = array('TIT' => 'v',              'EzWeb' => '46',              'SB' => '$GM');
        $this->_emoji['F972'] = array('TIT' => 'phone to',          'EzWeb' => '513',             'SB' => '$E$');
        $this->_emoji['F973'] = array('TIT' => 'mail to',           'EzWeb' => '784',             'SB' => '$E#');
        $this->_emoji['F974'] = array('TIT' => 'fax to',            'EzWeb' => '166',             'SB' => '$G+');
        $this->_emoji['F975'] = array('TIT' => 'i[h',           'EzWeb' => '[i[h]',       'SB' => '[i[h]');
        $this->_emoji['F976'] = array('TIT' => 'i[higtj', 'EzWeb' => '[i[h]',       'SB' => '[i[h]');
        $this->_emoji['F977'] = array('TIT' => '[',            'EzWeb' => '108',             'SB' => '$E#');
        $this->_emoji['F978'] = array('TIT' => 'hR',        'EzWeb' => '[hR]',        'SB' => '[hR]');
        $this->_emoji['F979'] = array('TIT' => 'hR|Cg',    'EzWeb' => '[DP]',            'SB' => '[DP]');
        $this->_emoji['F97A'] = array('TIT' => 'L',              'EzWeb' => '109',             'SB' => '');
        $this->_emoji['F97B'] = array('TIT' => '',              'EzWeb' => '299',             'SB' => 'mFREEn');
        $this->_emoji['F97D'] = array('TIT' => 'pX[h',        'EzWeb' => '120',             'SB' => '$G_');
        $this->_emoji['F97E'] = array('TIT' => 'L',            'EzWeb' => '118',             'SB' => '-');
        $this->_emoji['F980'] = array('TIT' => 'NA',            'EzWeb' => '324',             'SB' => '[CL]');
        $this->_emoji['F981'] = array('TIT' => 'T[`iׂj',  'EzWeb' => '119',             'SB' => '$E4');
        $this->_emoji['F982'] = array('TIT' => 'mdv',            'EzWeb' => '334',             'SB' => '$F2');
        $this->_emoji['F983'] = array('TIT' => 'ʒu',          'EzWeb' => '730',             'SB' => '-');
        $this->_emoji['F984'] = array('TIT' => 't[_C',    'EzWeb' => '[FD]',            'SB' => '$F1');
        $this->_emoji['F985'] = array('TIT' => 'V[v_C',  'EzWeb' => '818',             'SB' => '$F0');
        $this->_emoji['F986'] = array('TIT' => 'op',            'EzWeb' => '4',               'SB' => '[Q]');
        $this->_emoji['F987'] = array('TIT' => '1',                 'EzWeb' => '180',             'SB' => '$F<');
        $this->_emoji['F988'] = array('TIT' => '2',                 'EzWeb' => '181',             'SB' => '$F=');
        $this->_emoji['F989'] = array('TIT' => '3',                 'EzWeb' => '182',             'SB' => '$F>');
        $this->_emoji['F98A'] = array('TIT' => '4',                 'EzWeb' => '183',             'SB' => '$F?');
        $this->_emoji['F98B'] = array('TIT' => '5',                 'EzWeb' => '184',             'SB' => '$F@');
        $this->_emoji['F98C'] = array('TIT' => '6',                 'EzWeb' => '185',             'SB' => '$FA');
        $this->_emoji['F98D'] = array('TIT' => '7',                 'EzWeb' => '186',             'SB' => '$FB');
        $this->_emoji['F98E'] = array('TIT' => '8',                 'EzWeb' => '187',             'SB' => '$FC');
        $this->_emoji['F98F'] = array('TIT' => '9',                 'EzWeb' => '188',             'SB' => '$FD');
        $this->_emoji['F990'] = array('TIT' => '0',                 'EzWeb' => '325',             'SB' => '$FE');
        $this->_emoji['F9B0'] = array('TIT' => '',              'EzWeb' => '326',             'SB' => '$Fm');
        $this->_emoji['F991'] = array('TIT' => 'n[g',          'EzWeb' => '51',              'SB' => '$GB');
        $this->_emoji['F993'] = array('TIT' => '',              'EzWeb' => '265',             'SB' => '$GC');
        $this->_emoji['F994'] = array('TIT' => 'n[g',        'EzWeb' => '266',             'SB' => '$OG');
        $this->_emoji['F995'] = array('TIT' => '[',            'EzWeb' => '257',             'SB' => '$Gw');
        $this->_emoji['F996'] = array('TIT' => '',              'EzWeb' => '258',             'SB' => '$Gy');
        $this->_emoji['F997'] = array('TIT' => '`',            'EzWeb' => '441',             'SB' => '$Gx');
        $this->_emoji['F998'] = array('TIT' => '₾`',        'EzWeb' => '444',             'SB' => '$P\'');
        $this->_emoji['F999'] = array('TIT' => 'ӂӂ',          'EzWeb' => '327',             'SB' => '$P&');
        $this->_emoji['F99A'] = array('TIT' => 'Obh',            'EzWeb' => '731',             'SB' => '$FV');
        $this->_emoji['F99B'] = array('TIT' => '',          'EzWeb' => '343',             'SB' => '$G^');
        $this->_emoji['F99C'] = array('TIT' => 'C',          'EzWeb' => '224',             'SB' => '$EC');
        $this->_emoji['F99D'] = array('TIT' => '킢',          'EzWeb' => '-',               'SB' => '-');
        $this->_emoji['F99E'] = array('TIT' => 'LX}[N',        'EzWeb' => '273',             'SB' => '$G#');
        $this->_emoji['F99F'] = array('TIT' => '҂҂',          'EzWeb' => '420',             'SB' => '$ON');
        $this->_emoji['F9A0'] = array('TIT' => 'Ђ߂',          'EzWeb' => '77',              'SB' => '$E/');
        $this->_emoji['F9A1'] = array('TIT' => 'ނ',            'EzWeb' => '262',             'SB' => '$OT');
        $this->_emoji['F9A2'] = array('TIT' => 'p`',            'EzWeb' => '281',             'SB' => '$G-');
        $this->_emoji['F9A3'] = array('TIT' => 'e',              'EzWeb' => '268',             'SB' => '$O1');
        $this->_emoji['F9A4'] = array('TIT' => '[h',            'EzWeb' => '291',             'SB' => '$OF');
        $this->_emoji['F9A5'] = array('TIT' => 'obh',            'EzWeb' => '732',             'SB' => '$FX');
        $this->_emoji['F9A6'] = array('TIT' => '()',        'EzWeb' => '261',             'SB' => '$E\');
        $this->_emoji['F9A7'] = array('TIT' => 'I',                'EzWeb' => '2',               'SB' => '$GA');
        $this->_emoji['F9A8'] = array('TIT' => 'IH',              'EzWeb' => '733',             'SB' => 'IH');
        $this->_emoji['F9A9'] = array('TIT' => 'II',              'EzWeb' => '734',             'SB' => 'II');
        $this->_emoji['F9AA'] = array('TIT' => 'ǂiՌj',    'EzWeb' => '329',             'SB' => '-');
        $this->_emoji['F9AB'] = array('TIT' => '',          'EzWeb' => '330',             'SB' => '$OQ');
        $this->_emoji['F9AC'] = array('TIT' => '[',          'EzWeb' => '263',             'SB' => '$OQ');
        $this->_emoji['F9AD'] = array('TIT' => '_bV',          'EzWeb' => '282',             'SB' => '$OP');
        $this->_emoji['F9AE'] = array('TIT' => '[iLPj',  'EzWeb' => '-',               'SB' => '-');
        $this->_emoji['F9AF'] = array('TIT' => '[iLQj',  'EzWeb' => '735',             'SB' => '-');
        $this->_emoji['F9B1'] = array('TIT' => 'iAv',           'EzWeb' => '[Av]',      'SB' => '[Av]');
        $this->_emoji['F9B2'] = array('TIT' => 'iAvigtj', 'EzWeb' => '[Av]',      'SB' => '[Av]');
        $this->_emoji['F9B3'] = array('TIT' => 'TVc',           'EzWeb' => '335',             'SB' => '$G&');
        $this->_emoji['F9B4'] = array('TIT' => '܌z',        'EzWeb' => '290',             'SB' => '[z]');
        $this->_emoji['F9B5'] = array('TIT' => '',              'EzWeb' => '295',             'SB' => '$O<');
        $this->_emoji['F9B6'] = array('TIT' => 'W[Y',          'EzWeb' => '805',             'SB' => '[W[Y]');
        $this->_emoji['F9B7'] = array('TIT' => 'Xm{',            'EzWeb' => '221',             'SB' => '[Xm{]');
        $this->_emoji['F9B8'] = array('TIT' => '`y',          'EzWeb' => '48',              'SB' => '$OE');
        $this->_emoji['F9B9'] = array('TIT' => 'hA',              'EzWeb' => '[hA]',          'SB' => '[hA]');
        $this->_emoji['F9BA'] = array('TIT' => 'h',            'EzWeb' => '233',             'SB' => '$EO');
        $this->_emoji['F9BB'] = array('TIT' => 'p\R',          'EzWeb' => '337',             'SB' => '$G,');
        $this->_emoji['F9BC'] = array('TIT' => 'u^[',        'EzWeb' => '806',             'SB' => '$E#');
        $this->_emoji['F9BD'] = array('TIT' => '`',            'EzWeb' => '152',             'SB' => '[`]');
        $this->_emoji['F9BE'] = array('TIT' => 'M',              'EzWeb' => '149',             'SB' => '$O!');
        $this->_emoji['F9BF'] = array('TIT' => '',              'EzWeb' => '354',             'SB' => '$E.');
        $this->_emoji['F9C0'] = array('TIT' => 'w',              'EzWeb' => '72',              'SB' => '$GT');
        $this->_emoji['F9C1'] = array('TIT' => 'v',            'EzWeb' => '58',              'SB' => '[v]');
        $this->_emoji['F9C2'] = array('TIT' => ']',            'EzWeb' => '215',             'SB' => '$EV');
        $this->_emoji['F9C3'] = array('TIT' => '̂',            'EzWeb' => '423',             'SB' => '$OX');
        $this->_emoji['F9C4'] = array('TIT' => 'rv',            'EzWeb' => '25',              'SB' => '[rv]');
        $this->_emoji['F9C5'] = array('TIT' => 'lĂ',        'EzWeb' => '441',             'SB' => '$P#');
        $this->_emoji['F9C6'] = array('TIT' => 'قƂ',      'EzWeb' => '446',             'SB' => '$P*');
        $this->_emoji['F9C7'] = array('TIT' => '⊾',            'EzWeb' => '257',             'SB' => '$P5');
        $this->_emoji['F9C8'] = array('TIT' => '⊾2',           'EzWeb' => '351',             'SB' => '$E(');
        $this->_emoji['F9C9'] = array('TIT' => 'ՂȊ',    'EzWeb' => '779',             'SB' => '$P6');
        $this->_emoji['F9CA'] = array('TIT' => '{P[Ƃ',  'EzWeb' => '450',             'SB' => '$P.');
        $this->_emoji['F9CB'] = array('TIT' => 'ڂn[g',        'EzWeb' => '349',             'SB' => '$E&');
        $this->_emoji['F9CC'] = array('TIT' => 'wOK',            'EzWeb' => '287',             'SB' => '$G.');
        $this->_emoji['F9CD'] = array('TIT' => 'ׁ[',      'EzWeb' => '264',             'SB' => '$E%');
        $this->_emoji['F9CE'] = array('TIT' => 'EBN',          'EzWeb' => '348',             'SB' => '$P%');
        $this->_emoji['F9CF'] = array('TIT' => 'ꂵ',        'EzWeb' => '446',             'SB' => '$P*');
        $this->_emoji['F9D0'] = array('TIT' => '܂',          'EzWeb' => '443',             'SB' => '$P&');
        $this->_emoji['F9D1'] = array('TIT' => 'L2',               'EzWeb' => '440',             'SB' => '$P"');
        $this->_emoji['F9D2'] = array('TIT' => '',            'EzWeb' => '259',             'SB' => '$P1');
        $this->_emoji['F9D3'] = array('TIT' => '',                'EzWeb' => '791',             'SB' => '$P3');
        $this->_emoji['F9D4'] = array('TIT' => 'NG',                'EzWeb' => '[mf]',          'SB' => '[mf]');
        $this->_emoji['F9D5'] = array('TIT' => 'Nbv',          'EzWeb' => '143',             'SB' => '[Nbv]');
        $this->_emoji['F9D6'] = array('TIT' => 'Rs[Cg',      'EzWeb' => '81',              'SB' => '$Fn');
        $this->_emoji['F9D7'] = array('TIT' => 'g[h}[N',    'EzWeb' => '54',              'SB' => '$QW');
        $this->_emoji['F9D8'] = array('TIT' => 'l',            'EzWeb' => '218',             'SB' => '$E5');
        $this->_emoji['F9D9'] = array('TIT' => '}',            'EzWeb' => '279',             'SB' => '$O5');
        $this->_emoji['F9DA'] = array('TIT' => 'TCN',        'EzWeb' => '807',             'SB' => '-');
        $this->_emoji['F9DB'] = array('TIT' => 'g[h}[N',    'EzWeb' => '82',              'SB' => '$Fo');
        $this->_emoji['F9DC'] = array('TIT' => '댯Ex',        'EzWeb' => '1',               'SB' => '$Fr');
        $this->_emoji['F9DD'] = array('TIT' => '֎~',              'EzWeb' => '[]',            'SB' => '[]');
        $this->_emoji['F9DE'] = array('TIT' => '󎺁EȁE',  'EzWeb' => '387',             'SB' => '$FK');
        $this->_emoji['F9DF'] = array('TIT' => 'i}[N',        'EzWeb' => '[]',            'SB' => '[]');
        $this->_emoji['F9E0'] = array('TIT' => 'EȁE',  'EzWeb' => '386',             'SB' => '$FJ');
        $this->_emoji['F9E1'] = array('TIT' => '󍶉E',          'EzWeb' => '808',             'SB' => '');
        $this->_emoji['F9E2'] = array('TIT' => '㉺',          'EzWeb' => '809',             'SB' => '-');
        $this->_emoji['F9E3'] = array('TIT' => 'wZ',              'EzWeb' => '377',             'SB' => '$Ew');
        $this->_emoji['F9E4'] = array('TIT' => 'g',                'EzWeb' => '810',             'SB' => '$P^');
        $this->_emoji['F9E5'] = array('TIT' => 'xmR',            'EzWeb' => '342',             'SB' => '$G[');
        $this->_emoji['F9E6'] = array('TIT' => 'N[o[',        'EzWeb' => '53',              'SB' => '$E0');
        $this->_emoji['F9E7'] = array('TIT' => '',        'EzWeb' => '241',             'SB' => '[`F[]');
        $this->_emoji['F9E8'] = array('TIT' => '`[bv',      'EzWeb' => '113',             'SB' => '$O$');
        $this->_emoji['F9E9'] = array('TIT' => 'oii',            'EzWeb' => '739',             'SB' => '[oii]');
        $this->_emoji['F9EA'] = array('TIT' => '',            'EzWeb' => '434',             'SB' => '$Oe');
        $this->_emoji['F9EB'] = array('TIT' => '',                'EzWeb' => '811',             'SB' => '$E0');
        $this->_emoji['F9EC'] = array('TIT' => '݂',            'EzWeb' => '133',             'SB' => '$E8');
        $this->_emoji['F9ED'] = array('TIT' => '',                'EzWeb' => '235',             'SB' => '$GP');
        $this->_emoji['F9EE'] = array('TIT' => 'ɂ',          'EzWeb' => '244',             'SB' => '$Ob');
        $this->_emoji['F9EF'] = array('TIT' => 'V[gP[L',    'EzWeb' => '239',             'SB' => '$Gf');
        $this->_emoji['F9F0'] = array('TIT' => 'Ƃ',          'EzWeb' => '400',             'SB' => '$O+');
        $this->_emoji['F9F1'] = array('TIT' => 'ǂԂ',          'EzWeb' => '333',             'SB' => '$O`');
        $this->_emoji['F9F2'] = array('TIT' => 'p',              'EzWeb' => '424',             'SB' => '$OY');
        $this->_emoji['F9F3'] = array('TIT' => 'ނ',        'EzWeb' => '812',             'SB' => '[J^c]');
        $this->_emoji['F9F4'] = array('TIT' => 'Ђ悱',            'EzWeb' => '78',              'SB' => '$QC');
        $this->_emoji['F9F5'] = array('TIT' => 'yM',          'EzWeb' => '252',             'SB' => '$Gu');
        $this->_emoji['F9F6'] = array('TIT' => '',                'EzWeb' => '203',             'SB' => '$G9');
        $this->_emoji['F9F7'] = array('TIT' => '܂I',          'EzWeb' => '454',             'SB' => '$Gv');
        $this->_emoji['F9F8'] = array('TIT' => 'EbVbV',        'EzWeb' => '814',             'SB' => '$P$');
        $this->_emoji['F9F9'] = array('TIT' => 'E}',              'EzWeb' => '248',             'SB' => '$G:');
        $this->_emoji['F9FA'] = array('TIT' => 'u^',              'EzWeb' => '254',             'SB' => '$E+');
        $this->_emoji['F9FB'] = array('TIT' => 'COX',      'EzWeb' => '12',              'SB' => '$Gd');
        $this->_emoji['F9FC'] = array('TIT' => '',          'EzWeb' => '350',             'SB' => '$E\'');
        // 2006/11/20 Ή
        $this->_emoji['F992'] = array('TIT' => 'n[g',        'EzWeb' => '266',             'SB' => '$OG');
        $this->_emoji['F97C'] = array('TIT' => 'n[g',        'EzWeb' => '385',             'SB' => '$FI');
        $this->_emoji['F95C'] = array('TIT' => 'SOON',              'EzWeb' => '[SOON]',          'SB' => '[SOON]');
        $this->_emoji['F95D'] = array('TIT' => 'ON',                'EzWeb' => '[ON]',            'SB' => '[ON]');
        $this->_emoji['F95E'] = array('TIT' => 'END',               'EzWeb' => '[END]',           'SB' => '[END]');

    }

    // }}}

}

// }}}


/*
 * Local Variables:
 * mode: php
 * coding: iso-8859-1
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * indent-tabs-mode: nil
 * End:
 */
?>
